<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealerInternetSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Dealer Internet',
                'name' => 'Enabled',
                'config_key' => 'stock-dealer-internet-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 1,
                'description' => 'Import vehicle offers from Dealer Internet',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Dealer Internet',
                'name' => 'Username',
                'config_key' => 'stock-dealer-internet-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.stock-dealer-internet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Dealer Internet',
                'name' => 'Make to import',
                'config_key' => 'stock-dealer-internet-make-to-import',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.stock-dealer-internet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Dealer Internet',
                'name' => 'Default new vehicles to published',
                'config_key' => 'stock-dealer-internet-default-to-published',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
