<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BookingAvailabilityFutureMonthSettingSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Bookings',
                'name' => 'Booking Availability - treat previous months as next year',
                'config_key' => 'booking-availability-treat-previous-month-as-next-year',
                'type' => 'boolean',
                'value' => false,
                'description' => 'When enabled, booking availability requests for months earlier than current month '
                    . 'will retrieve availability for that month in the next year. ',
            ],
        ];
    }
}
