<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FinanceExampleTypeSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Type of finance example to show in list card',
                'config_key' => 'vehicle-list-load-finance-example-type',
                'type' => 'string',
                'value' => 'cheapest',
                'order' => 20,
                'choices' => [
                    ['value' => 'cheapest', 'name' => 'Cheapest'],
                    ['value' => 'PCP', 'name' => 'PCP'],
                    ['value' => 'HP', 'name' => 'HP'],
                ],
            ],
        ];
    }
}
