<?php

namespace App\Console\Commands;

use App\Imports\Blog\SandicliffeBlogImport;
use App\Imports\Blog\SandownBlogImport;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;

class BlogImport extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'blog:import';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import blog articles from specified provider';

    private static array $import_handlers = [
        'sandicliffe' => 'Sandicliffe',
        'sandown' => 'Sandown',
    ];

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $selected = $this->choice('Please select import handler', self::$import_handlers);
        match ($selected) {
            'sandicliffe' => (new SandicliffeBlogImport($this->output))->handle(),
            'sandown' => (new SandownBlogImport($this->output))->handle(),
            default => $this->error('Unknown provider')
        };

        return self::SUCCESS;
    }
}
