<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Vehicle;

class TrimVehicleUuids extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'vehicles:trim-uuids';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Trim vehicle UUIDs';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Vehicle::query()
            ->whereNotNull('uuid')
            ->chunk(100, fn(Collection $chunk) => $chunk->each(fn(Vehicle $vehicle) => $this->trim($vehicle)));
    }

    private function trim(Vehicle $vehicle): void
    {
        $vehicle->update([
            'uuid' => trim($vehicle->uuid),
        ]);
    }
}
