<?php

namespace App\Crm\Config;

use App\Contracts\AddsDealershipFields;
use App\Facades\Settings;
use Illuminate\Support\Facades\Mail;
use Mtc\Crm\Contracts\EnquiryAction;
use Mtc\Crm\Contracts\EnquiryActionModel;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\Crm\Mail\NewEnquiryMail;

class EnquiryMaxConfig
{
    public function enabled(): bool
    {
        return Settings::get('crm-enquiry-max-enabled');
    }

    public function clientId(): string
    {
        return Settings::get('crm-enquiry-max-client-id');
    }

    public function clientSecret(): string
    {
        return Settings::get('crm-enquiry-max-client-secret');
    }

    public function mode(): string
    {
        return config('services.enquiry-max.mode');
    }
}
