<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\CarSnipExportJob;
use App\Traits\ChecksForExportMap;
use Illuminate\Foundation\Bus\DispatchesJobs;

class CarSnip implements SalesChannel
{
    use DispatchesJobs;
    use ChecksForExportMap;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-car-snip-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.car_snip');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled() && !$this->hasActiveExportMap()) {
            $this->dispatch(new CarSnipExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'car-snip-dealer-id' => [
                'type' => 'text',
                'validation' => [
                    'required',
                ],
                'label' => 'Dealership name on CarSnip'
            ],
        ];
    }
}
