<?php

namespace App\Reporting;

use App\Contracts\ReportTile;
use Mtc\MercuryDataModels\PropertyCategory;

class PropertyCountTile extends ReportTile
{
    public function __construct(private PropertyCategory $taxonomyCategory)
    {
    }

    public function name(): string
    {
        return $this->taxonomyCategory->name;
    }

    public function value(): mixed
    {
        return $this->taxonomyCategory->count_active;
    }

    public function difference(): mixed
    {
        return 0;
    }

    public function secondaryValue(): mixed
    {
        return 0;
    }

    public function subtitle(): string
    {
        return 'Active';
    }

    public function differenceType(): string
    {
        return 'noChange';
    }

    public function secondaryValueName(): string
    {
        return '';
    }
}
