<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AlternateOpenTimesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Secondary open/close times',
                'config_key' => 'dealership-second-open-times',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enables second open/close time windows per dealership',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Dealerships',
                'name' => 'Secondary open/close time name',
                'config_key' => 'dealership-secondary-open-close-time-name',
                'type' => 'string',
                'value' => '',
                'description' => 'Descriptive name - e.g. aftersales',
            ],
        ];
    }
}
