<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ChatSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'LivePerson',
                'name' => 'Enabled',
                'config_key' => 'chat-live-person-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://www.liveperson.com/" target="_blank">LivePerson</a> chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'LivePerson',
                'name' => 'Client ID',
                'config_key' => 'chat-live-person-client_id',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.chat-live-person-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'LiveChat',
                'name' => 'Enabled',
                'config_key' => 'chat-live-chat-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://www.livechat.com/" target="_blank">LiveChat</a> chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'LiveChat',
                'name' => 'Client ID',
                'config_key' => 'chat-live-chat-client_id',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.chat-live-chat-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'LiveChat',
                'name' => 'License ID',
                'config_key' => 'chat-live-chat-license_id',
                'type' => 'string',
                'value' => '',
                'order' => 2,
                'validation_rules' => [
                    "required_if:values.chat-live-chat-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Gubagoo',
                'name' => 'Enabled',
                'config_key' => 'chat-gubagoo-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://gubagoo.com/car-dealer-chat-smart" target="_blank">Gubagoo</a> chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Gubagoo',
                'name' => 'Account ID',
                'config_key' => 'chat-gubagoo-account_id',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.chat-gubagoo-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Keyloop Leads',
                'name' => 'Enabled',
                'config_key' => 'chat-rapid-rtc-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://www.keyloop.com/marketing/keyloop-leads" target="_blank">Keyloop Leads</a> chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Keyloop Leads',
                'name' => 'Account Key',
                'config_key' => 'chat-rapid-rtc-key',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.chat-rapid-rtc-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'ZenDesk',
                'name' => 'Enabled',
                'config_key' => 'chat-zendesk-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://www.zendesk.com/service/messaging/live-chat/" target="_blank">Zendesk</a> chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'ZenDesk',
                'name' => 'Account Key',
                'config_key' => 'chat-zendesk-key',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.chat-zendesk-enabled,true"
                ]
            ],
        ];
    }
}
