<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class StoreUserFinanceFlag extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Store user requested finance quotes',
                'config_key' => 'finance-store-user-requested-quotes',
                'type' => 'boolean',
                'value' => false,
                'description' => 'When enabled user requested quotes from calculator will be stored in system. ' .
                    'These rates will be made available for other system users looking for examples',
                'order' => 19,
            ],
        ];
    }
}
