<?php

namespace App;

use App\Facades\Settings;
use Illuminate\Support\Str;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;

class LeaseVehicleRepository
{
    public function buildSlug(KeyloopLeaseVehicleVariant $vehicle): string
    {
        $slug = match (Settings::get('automotive-lease-vehicles-url_building_format')) {
            'make-model' => $this->buildSlugFromMakeModel($vehicle),
            'title' => Str::slug($vehicle->name),
            'uuid' => Str::slug($vehicle->external_variant_id),
            default => $this->buildSlugFromMakeModel($vehicle),
        };

        return $vehicle->ensureSlugFromString($slug);
    }

    protected function buildSlugFromMakeModel(KeyloopLeaseVehicleVariant $vehicle): string
    {
        return Str::slug(
            ($vehicle->make?->name ?? '') . '-' . ($vehicle->model?->name ?? '')
        );
    }
}
