<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AutoTraderStockSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            // Incoming
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'General',
                'name' => 'Master advertiser ID',
                'config_key' => 'auto-trader-advertiser-id',
                'type' => 'string',
                'value' => false,
                'description' => 'Advertiser ID used for situations where a dealership '
                    . 'specific one is not available - e.g. valuation',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Enabled',
                'config_key' => 'stock-auto-trader-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => '<a href="https://www.autotrader.co.uk/" target="_blank">AutoTrader</a> to website sync integration.'
                    . ' When enabled, will also add extra field against dealerships for mapping locations.',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Synchronize new vehicles',
                'config_key' => 'stock-auto-trader-sync-new-vehicles',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Synchronize used vehicles',
                'config_key' => 'stock-auto-trader-sync-used-vehicles',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Only import vehicles with price set',
                'config_key' => 'stock-auto-trader-sync-with-price',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'description' => 'Will skip over vehicles without a price when set disabled',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Synchronize images',
                'config_key' => 'stock-auto-trader-sync-images',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'description' => 'Retrieve images and add them to website when importing'
            ],
            // Outgoing
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-auto-trader-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Publish vehicles to AutoTrader',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Update status on website when status changes on AutoTrader',
                'config_key' => 'automotive-sales-channels-auto-trader-pull-status',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Remove vehicles from AutoTrader when status changes to Sold',
                'config_key' => 'automotive-sales-channels-auto-trader-unpublish-sold',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock push from website to AutoTrader',
                'name' => 'Remove vehicles from AutoTrader when status changes to Reserved',
                'config_key' => 'automotive-sales-channels-auto-trader-unpublish-reserved',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
