<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EnquiryVehicleStatsSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Enquiries',
                'group' => 'Response',
                'name' => 'Show vehicle stats after enquiry submission',
                'description' => 'When enabled, vehicle views and enquiry count are returned after an enquiry',
                'config_key' => 'crm-enquiry-vehicle-stats-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 10,
                'feature' => 'enquiry-vehicle-stats',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Enquiries',
                'group' => 'Response',
                'name' => 'Minimum views threshold',
                'description' => 'Only show vehicle stats summary if the total views exceeds this threshold (0 = always show)',
                'config_key' => 'crm-enquiry-vehicle-stats-views-threshold',
                'type' => 'number',
                'value' => 0,
                'order' => 11,
                'feature' => 'enquiry-vehicle-stats',
            ],
        ];
    }
}
