<?php

namespace App;

use App\Contracts\AIContentDriver;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

class AIContentRepository
{
    protected AIContentDriver $driver;

    public function hasEnabledIntegration(): bool
    {
        return $this->getEnabledIntegrations()->isNotEmpty();
    }

    public function getDescription(Vehicle|VehicleOffer $model): string
    {
        return $this->getDriver()->getDescription($model);
    }

    public function canGenerateDescriptionOnImport(): bool
    {
        return $this->getDriver()->canGenerateDescriptionOnImport();
    }

    protected function getDriver(): AIContentDriver
    {
        return $this->driver ?? $this->initializeDriver();
    }

    protected function initializeDriver(): AIContentDriver
    {
        return $this->getEnabledIntegrations()
            ->map(fn($integration) => App::make($integration['class']))
            ->filter(fn($integration) => $integration instanceof AIContentDriver)
            ->firstOrFail();
    }

    protected function getEnabledIntegrations(): \Illuminate\Support\Collection
    {
        return (new IntegrationRepository())->getEnabledForType('ai-content');
    }
}
