<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\MercuryDataModels\Seo404;

class Seo404Export implements FromCollection, WithHeadings, ShouldAutoSize
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Seo404::query()
            ->select(['path', 'hits', 'created_at', 'updated_at'])
            ->get();
    }

    /**
     * Export file heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'path',
            'hits',
            'created_at',
            'updated_at',
        ];
    }
}
