<?php

namespace App\Modules\Stock;

use App\Contracts\AddsDealershipFields;
use App\Contracts\StockProvider;
use App\Facades\Settings;
use App\Modules\Stock\CustomEndpoint\PCKReservedFeed;

class AutoGrab implements StockProvider
{
    public function enabled(): bool
    {
        return Settings::get('stock-autograb-enabled') ?? false;
    }

    public function name(): string
    {
        return 'AutoGrab';
    }

    public function runScheduledImport(bool $fullSync = true): void
    {
        // No scheduled process, only notifications
    }
}
