<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BcaCapValuationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BCA',
                'name' => 'Enabled',
                'config_key' => 'valuation-bca-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BCA',
                'name' => 'Live',
                'config_key' => 'valuation-bca-live',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BCA',
                'name' => 'Api Key',
                'config_key' => 'valuation-bca-api_key',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BCA',
                'name' => 'Api Secret',
                'config_key' => 'valuation-bca-api_secret',
                'type' => 'secret',
                'min_tier' => 'pro',
                'value' => '',
            ],

            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'CAP',
                'name' => 'Enabled',
                'config_key' => 'valuation-cap-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'CAP',
                'name' => 'Subscriber Id',
                'config_key' => 'valuation-cap-subscriber_id',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'CAP',
                'name' => 'Password',
                'config_key' => 'valuation-cap-password',
                'type' => 'secret',
                'min_tier' => 'pro',
                'value' => '',
            ],
        ];
    }
}
