<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LeaseVehicleLabelSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Lease Vehicles',
                'name' => 'Lease Vehicle labels',
                'config_key' => 'lease-vehicle-labels-enabled',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'standard',
                'description' => 'Enable lease vehicle labels'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Lease Vehicles',
                'name' => 'Use advanced label rules',
                'config_key' => 'lease-vehicle-labels-advanced-rules-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Use advanced rules for matching lease vehicle labels',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Lease Vehicles',
                'name' => 'Number of days for Just Arrived label',
                'config_key' => 'lease-vehicle-labels-just-arrived-days',
                'type' => 'number',
                'value' => 30,
                'description' => 'The number of days until "Just Arrived" will be displayed',
                'validation_rules' => [
                    "required_if:values.lease-vehicle-labels-enabled,true"
                ]
            ],
        ];
    }
}
