<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class RemoveBgSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }
    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Remove.bg',
                'name' => 'Remove.bg enabled',
                'config_key' => 'remove-bg-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enable background removing with
                    <a href="https://www.remove.bg/" target="_blank">remove.bg</a>',
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Remove.bg',
                'name' => 'API Key',
                'config_key' => 'remove-bg-api_key',
                'type' => 'hidden',
                'value' => '',
                'description' => '',
                'validation_rules' => [
                    "required_if:values.remove-bg-enabled,true"
                ]
            ],
        ];
    }
}
