<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SkodaDeliveryPriceSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Skoda',
                'name' => 'Delivery price',
                'config_key' => 'stock-skoda-delivery-price',
                'type' => 'int',
                'value' => 0,
                'description' => 'Extra delivery price that will be added on import',
                'order' => 4,
            ],
        ];
    }
}
