<?php

namespace App;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Country;

class CountryRepository
{
    /**
     * Return all countries with name and code
     */
    public function getAll(): Collection
    {
        return Country::query()
            ->select([
                'name',
                'code'
            ])
            ->get();
    }

    /**
     * Check if a country requires postcode
     */
    public function requiresPostcode(string $countryCode): bool
    {
        return Country::query()
            ->where('code', $countryCode)
            ->where('has_postcodes', 1)
            ->exists();
    }
}
