<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\ReleaseNoteFactory;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class ReleaseNote extends Model
{
    use CentralConnection;
    use HasFactory;

    protected $fillable = [
        'is_published',
        'published_at',
        'title',
        'content',
        'data',
    ];

    protected $casts = [
        'data' => 'array',
        'is_published' => 'bool',
        'published_at' => 'datetime:Y-m-d',
    ];

    protected static function newFactory()
    {
        return ReleaseNoteFactory::new();
    }

    public function scopePublished(Builder $query)
    {
        $query->where('is_published', 1);
    }
}
