<?php

namespace Tests\Tenant;

use App\Facades\Feature;
use Carbon\Carbon;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleReservations\Reservation;
use Tests\TenantTestCase;
use Tests\UserForTenant;

class ReservationTest extends TenantTestCase
{
    use UserForTenant;

    public function testIndex()
    {
        Feature::setEnabled(tenant(), ['reservations']);

        $vehicle = Vehicle::factory()->create();
        Reservation::factory()->create([
            'vehicle_id' => $vehicle->id,
            'data' => null,
            'confirmed_at' => Carbon::now(),
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.reservations.index'));

        $response->assertStatus(200);

        $this->assertStringContainsString($vehicle->registration_number, $response->json('data.0.metaItems.vehicle_description'));
    }

    public function testIndexWithReservationData()
    {
        Feature::setEnabled(tenant(), ['reservations']);

        $vehicle = Vehicle::factory()->create();
        Reservation::factory()->create([
            'vehicle_id' => $vehicle->id,
            'data' =>[
                'vehicle' => [
                    'description' => 'foo',
                ],
            ],
            'confirmed_at' => Carbon::now(),
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.reservations.index'));

        $response->assertStatus(200);

        $this->assertEquals('foo', $response->json('data.0.metaItems.vehicle_description'));
    }
}
