<?php

namespace App\Providers;

use App\Services\MeilisearchService;
use Illuminate\Support\ServiceProvider;

class MeilisearchServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->singleton(MeilisearchService::class, function () {
            return new MeilisearchService();
        });
    }

    public function boot(): void
    {
        $this->publishes([
            __DIR__ . '/../../config/meilisearch.php' => config_path('meilisearch.php'),
        ], 'meilisearch-config');
    }
}
