<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class TikTokTracker implements Arrayable
{
    public function toArray()
    {
        $code = Settings::get('tracking-tiktok-code');
        return [
            [
                "body" => '!function (w, d, t) { w.TiktokAnalyticsObject=t;var ttq=w[t]=w[t]||[];ttq.methods=['
                    . '"page","track","identify","instances","debug","on","off","once","ready","alias","group",'
                    . '"enableCookie","disableCookie"],ttq.setAndDefer=function(t,e){t[e]=function(){t.push([e].'
                    . 'concat(Array.prototype.slice.call(arguments,0)))}};for(var i=0;i<ttq.methods.length;i++)ttq.set'
                    . 'AndDefer(ttq,ttq.methods[i]);ttq.instance=function(t){for(var e=ttq._i[t]||[],n=0;n<ttq.methods.'
                    . 'length;n++)ttq.setAndDefer(e,ttq.methods[n]);return e},ttq.load=function(e,n){var i="https://'
                    . 'analytics.tiktok.com/i18n/pixel/events.js";ttq._i=ttq._i||{},ttq._i[e]=[],ttq._i[e]._u=i,ttq._'
                    . 't=ttq._t||{},ttq._t[e]=+new Date,ttq._o=ttq._o||{},ttq._o[e]=n||{};var o=document.createElement'
                    . '("script");o.type="text/javascript",o.async=!0,o.src=i+"?sdkid="+e+"&lib="+t;var a=document.'
                    . 'getElementsByTagName("script")[0];a.parentNode.insertBefore(o,a)}; ttq.load(\'' . $code . '\'); '
                    . 'ttq.page();}(window, document, \'ttq\');',
                'data-consent' => 'marketing'
            ]
        ];
    }
}
