<?php

namespace App\Http\Controllers;

use App\Http\Resources\LeaseVehicleAction\LoadsLeaseVehicleAction;
use App\Http\Resources\LeaseVehicleResource;
use App\LeaseVehicleRepository;
use App\Traits\CacheObject;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;

class LeaseVehicleController extends Controller
{
    use CacheObject;
    use LoadsLeaseVehicleAction;

    public function actions(Request $request, KeyloopLeaseVehicleVariant $variant)
    {
        return response([
            'actions' => $this->getLeaseVehicleActions($variant),
        ]);
    }

    public function show(Request $request, KeyloopLeaseVehicleVariant $variant)
    {
        return $this->cache('lease-vehicle-show-' . $variant->slug, 2, function () use ($variant) {
            return [
                'data' => new LeaseVehicleResource($variant),
            ];
        });
    }

    public function getFeatured(Request $request, LeaseVehicleRepository $repository)
    {
        return response([
            'name' => __('automotive.cross-sell.featured'),
            'items' => $repository
                ->featured()
                ->toArray($request)
        ]);
    }
}
