<?php

namespace Tests\Tenant;

use App\PageRepository;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Mtc\ContentManager\PageStatus;
use Mtc\MercuryDataModels\Page;
use Tests\TenantTestCase;

class PageRepositoryTest extends TenantTestCase
{
    public function testListing()
    {
        $newest_foo = Page::factory(1)->create([
            'category' => 'foo',
            'published_at' => Carbon::now()->subDays(),
            'status' => PageStatus::PUBLISHED->value,
        ]);
        Page::factory(5)->create([
            'category' => 'foo',
            'published_at' => Carbon::now()->subDays(2),
            'status' => PageStatus::PUBLISHED->value,
        ]);
        $oldest_foo = Page::factory(1)->create(['category' => 'foo', 'published_at' => Carbon::now()->subDays(3)]);

        Page::factory(1)->create(['category' => 'baz', 'published_at' => Carbon::now()->subDays(4)]);
        Page::factory(10)->create(['category' => 'baz', 'published_at' => Carbon::now()->subDays(5)]);
        $oldest_baz = Page::factory(1)->create(['category' => 'baz', 'published_at' => Carbon::now()->subDays(5)]);

        $repository = (new PageRepository());
        $listing = $repository->listing('foo');
        $this->assertInstanceOf(Collection::class, $listing);
        $this->assertEquals(6, $listing->count());
        $this->assertTrue($newest_foo->first()->is($listing->first()));


        $listing = $repository->listing('foo', 10);
        $this->assertEquals(6, $listing->count());
    }
}
