<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Http\Resources\SiteResource;
use Tests\TenantTestCase;

class TrackingScriptTest extends TenantTestCase
{
    public function testEnabledTrackers()
    {
        $resource = (new SiteResource([]))->toArray(request());
        $this->assertArrayHasKey('scripts', $resource);
        $this->assertIsArray($resource['scripts']);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'seo-ga_id',
            'value' => 'G-112233',
            'type' => 'string',
        ]);
        $resource = (new SiteResource([]))->toArray(request());
        $this->assertCount(1, $resource['scripts']);
        $this->assertStringContainsString('googletagmanager', $resource['scripts'][0]['body']);
        $this->assertStringContainsString('G-112233', $resource['scripts'][0]['body']);
        Settings::update('seo-ga_id', null);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'tracking-tiktok-code',
            'value' => 'foo-baz-bar',
            'type' => 'string',
        ]);
        $resource = (new SiteResource([]))->toArray(request());
        $this->assertCount(1, $resource['scripts']);
        $this->assertStringContainsString('TiktokAnalytics', $resource['scripts'][0]['body']);
        $this->assertStringContainsString('foo-baz-bar', $resource['scripts'][0]['body']);
        Settings::update('tracking-tiktok-code', null);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'tracking-facebook-code',
            'value' => 'foo-facebook-bar',
            'type' => 'string',
        ]);
        $resource = (new SiteResource([]))->toArray(request());
        $this->assertCount(1, $resource['scripts']);
        $this->assertStringContainsString('f,b,e,v,n,t,s', $resource['scripts'][0]['body']);
        $this->assertStringContainsString('foo-facebook-bar', $resource['scripts'][0]['body']);
        Settings::update('tracking-facebook-code', null);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'tracking-hotjar-code',
            'value' => 'foo-hotjar-bar',
            'type' => 'string',
        ]);
        $resource = (new SiteResource([]))->toArray(request());
        $this->assertCount(1, $resource['scripts']);
        $this->assertStringContainsString('hotjar', $resource['scripts'][0]['body']);
        $this->assertStringContainsString('foo-hotjar-bar', $resource['scripts'][0]['body']);
        Settings::update('tracking-hotjar-code', null);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'tracking-userback-token',
            'value' => 'foo-userback-token',
            'type' => 'string',
        ]);
        $resource = (new SiteResource([]))->toArray(request());
        $this->assertCount(1, $resource['scripts']);
        $this->assertStringContainsString('window.Userback', $resource['scripts'][0]['body']);
        $this->assertStringContainsString('foo-userback-token', $resource['scripts'][0]['body']);
        Settings::update('tracking-userback-token', null);
    }
}
