<?php

namespace App\Modules\Valuation\Config;

use App\Facades\Settings;

class BCAConfig extends \Mtc\VehicleValuation\Config\BCAConfig
{
    public function enabled(): bool
    {
        return Settings::get('valuation-bca-enabled') ?? false;
    }

    public function apiKey(): string
    {
        return Settings::get('valuation-bca-api_key') ?? '';
    }

    public function apiSecret(): string
    {
        return Settings::get('valuation-bca-api_secret') ?? '';
    }

    public function live(): bool
    {
        return Settings::get('valuation-bca-live') ?? true;
    }

    public function locationId(): string
    {
        return Settings::get('valuation-bca-location-id') ?? '';
    }
}
