<?php

namespace Tests\Feature;

use App\Facades\Settings;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Http;
use Mtc\VehicleLookup\VehicleLookupService;
use Tests\TestCase;

class VehicleLookupTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testEVALookup()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'lookup-eva-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        Http::fake([
            'https://www-test.evaautomotive.co.uk/api-auth/oauth2/token*' => Http::response([
                'access_token' => 'abc123',
            ]),
            'https://www-test.evaautomotive.co.uk/api/v1/vehiclelookup/foo' => Http::response([
                'Make' => 'BMW',
                'Model' => '3 Series',
                'Derivative' => 'xDrive',
                'DateOfFirstRegistration' => '2024-01-01',
                'BodyStyle' => 'saloon',
                'Fuel' => 'petrol',
                'Transmission' => 'automatic',
                'ExteriorColour' => 'red',
                'EngineCapacity' => '2000',
                'NoOfDoors' => '4',
                'VINSerialNumber' => 'abcxyz',
            ]),
            '*' => Http::response([], 400),
        ]);

        $response = (new VehicleLookupService())->findByVRM('foo', 12345);

        $this->assertEquals('BMW', $response->make);
        $this->assertEquals('3 Series', $response->model);
        $this->assertEquals('xDrive', $response->derivative);
        $this->assertEquals('2024-01-01', $response->registration_date);
        $this->assertEquals('saloon', $response->body_type);
        $this->assertEquals('saloon', $response->body_style);
        $this->assertEquals('petrol', $response->fuel_type);
        $this->assertEquals('automatic', $response->transmission);
        $this->assertEquals('red', $response->colour);
        $this->assertEquals('2000', $response->engine_capacity_cc);
        $this->assertEquals('4', $response->doors);
        $this->assertEquals('abcxyz', $response->vin);
    }
}
