<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Http\Resources\PhoneNumberDisplay;
use App\Http\Resources\SiteResource;
use App\Http\Resources\UiBrands;
use App\Http\Resources\UiResponsiveProductList;
use App\PageRepository;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\PageStatus;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\Menu;
use Mtc\MercuryDataModels\MenuEntry;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\FilterSettingSeed;
use Tests\TestCase;

class PageRepositoryTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    public function testListing()
    {
        $newest_foo = Page::factory(1)->create([
            'category' => 'foo',
            'published_at' => Carbon::now()->subDays(),
            'status' => PageStatus::PUBLISHED->value,
        ]);
        Page::factory(5)->create([
            'category' => 'foo',
            'published_at' => Carbon::now()->subDays(2),
            'status' => PageStatus::PUBLISHED->value,
        ]);
        $oldest_foo = Page::factory(1)->create(['category' => 'foo', 'published_at' => Carbon::now()->subDays(3)]);

        Page::factory(1)->create(['category' => 'baz', 'published_at' => Carbon::now()->subDays(4)]);
        Page::factory(10)->create(['category' => 'baz', 'published_at' => Carbon::now()->subDays(5)]);
        $oldest_baz = Page::factory(1)->create(['category' => 'baz', 'published_at' => Carbon::now()->subDays(5)]);

        $repository = (new PageRepository());
        $listing = $repository->listing('foo');
        $this->assertInstanceOf(Collection::class, $listing);
        $this->assertEquals(6, $listing->count());
        $this->assertTrue($newest_foo->first()->is($listing->first()));


        $listing = $repository->listing('foo', 10);
        $this->assertEquals(6, $listing->count());
    }
}
