<?php

namespace Tests;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LeaseFilterSettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach ($this->getData() as $setting) {
            Settings::make($setting);
        }
    }

    private function getData(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Make',
                'config_key' => 'automotive-vehicle-filters-make',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Model',
                'config_key' => 'automotive-vehicle-filters-model',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Body Style',
                'config_key' => 'automotive-vehicle-filters-body_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Colour',
                'config_key' => 'automotive-vehicle-filters-colour',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Door Count',
                'config_key' => 'automotive-vehicle-filters-door_count',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Engine Size',
                'config_key' => 'automotive-vehicle-filters-engine_size',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Fuel Type',
                'config_key' => 'automotive-vehicle-filters-fuel_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Transmission Type',
                'config_key' => 'automotive-vehicle-filters-transmission',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Seat Count',
                'config_key' => 'automotive-vehicle-filters-seats',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Engine Size Min',
                'config_key' => 'automotive-vehicle-filters-engine_size_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Engine Size Max',
                'config_key' => 'automotive-vehicle-filters-engine_size_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Seats Min',
                'config_key' => 'automotive-vehicle-filters-seats_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Seats Max',
                'config_key' => 'automotive-vehicle-filters-seats_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Doors Min',
                'config_key' => 'automotive-vehicle-filters-doors_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Doors Max',
                'config_key' => 'automotive-vehicle-filters-doors_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Vehicle Type',
                'config_key' => 'automotive-vehicle-filters-vehicle_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Cheapest Lease Variant',
                'config_key' => 'automotive-vehicle-filters-cheapest_lease_variant',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Doors Min',
                'config_key' => 'automotive-vehicle-filters-price_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Doors Max',
                'config_key' => 'automotive-vehicle-filters-price_max',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Doors Min',
                'config_key' => 'automotive-vehicle-filters-price_monthly_min',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Doors Max',
                'config_key' => 'automotive-vehicle-filters-price_monthly_max',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
