<?php

namespace App\Tracking;

use App\Facades\Settings;
use Illuminate\Contracts\Support\Arrayable;

class RedditTracker implements Arrayable
{
    public function toArray()
    {
        $pixelId = Settings::get('tracking-reddit-pixel-id');
        return [
            [
                "body" => '!function(w,d){'
                    . 'if(!w.rdt){'
                    . '  var p=w.rdt=function(){'
                    . '    p.sendEvent?p.sendEvent.apply(p,arguments):p.callQueue.push(arguments);'
                    . '  };'
                    . '  p.callQueue=[];'
                    . '  var t=d.createElement("script");'
                    . '  t.src="https://www.redditstatic.com/ads/pixel.js";'
                    . '  t.async=!0;'
                    . '  var s=d.getElementsByTagName("script")[0];'
                    . '  s.parentNode.insertBefore(t,s);'
                    . '}'
                    . '}(window,document);'
                    . 'rdt("init", "' . $pixelId . '");'
                    . 'rdt("track", "PageVisit");',
                'data-consent' => 'marketing'
            ]
        ];
    }
}
