<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Meilisearch Host
    |--------------------------------------------------------------------------
    |
    | This is the URL to your Meilisearch instance.
    |
    */
    'host' => env('MEILISEARCH_HOST', 'http://meilisearch:7700'),

    /*
    |--------------------------------------------------------------------------
    | Meilisearch API Key
    |--------------------------------------------------------------------------
    |
    | This is your Meilisearch API key (master key for admin operations).
    |
    */
    'key' => env('MEILISEARCH_KEY', ''),

    /*
    |--------------------------------------------------------------------------
    | Vehicle Index Settings
    |--------------------------------------------------------------------------
    |
    | Configuration for the vehicles index including filterable and sortable
    | attributes. These are used when setting up the index and for querying.
    |
    */
    'vehicle_index' => [
        'name' => 'vehicles',

        'filterable_attributes' => [
            'tenant_id',
            'make_id',
            'make_slug',
            'model_id',
            'model_slug',
            'body_style_id',
            'body_style_slug',
            'transmission_id',
            'transmission_slug',
            'fuel_type_id',
            'fuel_type_slug',
            'drivetrain_id',
            'dealership_id',
            'dealership_slug',
            'franchise_id',
            'colour',
            'colour_slug',
            'is_new',
            'is_published',
            'is_sold',
            'is_reserved',
            'is_demo',
            'is_vat_applicable',
            'type',
            'vehicle_category',
            'price',
            'monthly_price',
            'manufacture_year',
            'odometer_km',
            'odometer_mi',
            'engine_size_cc',
            'door_count',
            'seat_count',
            'co2',
            'label_ids',
            'feature_ids',
            'stock_status',
            'trim_slug',
            '_geo',
        ],

        'sortable_attributes' => [
            'created_at',
            'price',
            'monthly_price',
            'manufacture_year',
            'odometer_km',
            'odometer_mi',
        ],

        'searchable_attributes' => [
            'title',
            'derivative',
            'registration_number',
            'make_name',
            'model_name',
            'colour',
            'trim',
            'description',
        ],

        // Maximum total hits for pagination (Meilisearch default is 1000)
        'max_total_hits' => 200000,
    ],
];
