<?php

namespace App;

use App\Facades\Settings;
use App\Http\Resources\LeaseVehicleList;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Config;
use Mtc\Filter\Contracts\FilterObject;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;

class LeaseVehicleFilterObject implements FilterObject
{
    public function createQuery(): Builder
    {
        return KeyloopLeaseVehicleVariant::query()
            ->active()
            ->withRelationshipsForCardView();
    }

    public function getResults(Builder $query): LengthAwarePaginator
    {
        $pageLimit = Settings::get('filter-results-per-page', Config::get('filter.result_page_limit'));

        if ($this->hasCatalogOffers()) {
            $pageLimit--;
        }

        return $query->paginate(request('perPage', $pageLimit));
    }

    public function format(LengthAwarePaginator $results): JsonResource
    {
        return new LeaseVehicleList($results, $this->getCatalogOffer(), true);
    }

    public function applyFilter(Builder $query): void
    {
        // no active scope or equivalent for lease variants
    }

    public function additionalSortOptions($activeSortOptionName = '')
    {
        return [];
    }

    public function sortOptionName(): string
    {
        return 'lease-vehicles';
    }

    /**
     * @return bool
     */
    private function hasCatalogOffers(): bool
    {
        return false;
    }

    /**
     * @return Model|Builder|null
     */
    private function getCatalogOffer(): Model|Builder|null
    {
        return null;
    }
}
