<?php

namespace Tests\Data;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class IvendiUsernameSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'iVendi Username',
                'config_key' => 'finance-ivendi-username',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'description' => 'iVendi finance integration username',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'iVendi domain session ID',
                'config_key' => 'finance-ivendi-domain-session-id',
                'min_tier' => 'standard',
                'type' => 'string',
                'value' => '',
                'description' => 'iVendi finance domain session ID',
            ],
        ];
    }
}
