<?php

namespace Tests\Data;

use Illuminate\Database\Seeder;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\ContentManager\Models\Template;
use Mtc\ContentManager\Models\TemplateElement;
use Mtc\ContentManager\PageStatus;
use Mtc\MercuryDataModels\GlobalContent;

class TemplateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Template::reguard();
        Template::query()->truncate();
        TemplateElement::query()->truncate();
        collect($this->getList())
            ->each(function ($entry) {
                $template = Template::query()->create($entry);

                $this->addElements($template, $entry['elements'] ?? []);
            });
    }

    private function addElements($owner, $elementList)
    {
        collect($elementList)
            ->each(function ($element) use ($owner) {
                if ($owner instanceof Template) {
                    $element['template_id'] = $owner->id;
                    $entry = $owner->elements()->create($element);
                } else {
                    $element['template_id'] = $owner->template_id;
                    $element['parent_id'] = $owner->id;
                    $entry = $owner->subContent()->create($element);
                }

//                if (!empty($element['children'])) {
//                    $this->addElements($entry, $element['children']);
//                }
            });
    }

    public function getList()
    {
        return [
            [
                'name' => 'Homepage',
                'slug' => 'home',
                'status' => PageStatus::PUBLISHED->value,
                'elements' => $this->homeContent(),
            ],
            [
                'name' => 'Full Page Advert',
                'slug' => 'full-page-advert',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'Offers Landing',
                'slug' => 'offers-list',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'New Vehicle Offer',
                'slug' => 'new-vehicle-offer',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'Motability Offer',
                'slug' => 'motability-offer',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'EV Offer',
                'slug' => 'ev-offer',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'Services Landing',
                'slug' => 'services-list',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'View Service Offer',
                'slug' => 'services-show',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'Locations',
                'slug' => 'locations-list',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'View Location',
                'slug' => 'location-show',
                'status' => PageStatus::PUBLISHED->value,
            ],
            [
                'name' => 'News Landing',
                'slug' => 'news-landing',
                'status' => PageStatus::PUBLISHED->value,
                'elements' => $this->newsLanding(),
            ],
            [
                'name' => 'News Article',
                'slug' => 'news-article',
                'status' => PageStatus::PUBLISHED->value,
                'elements' => $this->newsArticle(),
                'meta' => [
                    'flexible' => true,
                ],
            ],
            [
                'name' => 'Generic Content Page',
                'slug' => 'general',
                'status' => PageStatus::PUBLISHED->value,
                'elements' => $this->newsArticle(),
                'meta' => [
                    'flexible' => true,
                ],
            ],
        ];
    }

    private function homeContent(): array
    {
        return [
            [
                'name' => 'Hero',
                'element_id' => ContentElement::query()->where('slug', 'hero')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 4,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],

            [
                'name' => 'Featured vehicles',
                'global_content_id' => GlobalContent::query()->where('slug', 'featured-vehicles')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'icon' => 'cars',
                    'nestable' => false,
                    'componentName' => false,
                    'nestedLimit' => false,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],

            [
                'name' => 'Call to actions',
                'element_id' => ContentElement::query()->where('slug', 'call-to-action-list')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 4,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],

            [
                'name' => 'News listing',
                'element_id' => ContentElement::query()->where('slug', 'recent-articles')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 4,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],
        ];
    }

    private function newsLanding(): array
    {
        return [
            [
                'name' => 'Heading',
                'field_type' => 'text',
                'element_id' => ContentElement::query()->where('slug', 'title')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'icon' => 'layer-group',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 4,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],

            [
                'name' => 'News Articles',
                'element_id' => ContentElement::query()->where('slug', 'news-page-list')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'icon' => 'layer-group',
                    'nestable' => false,
                    'componentName' => false,
                    'nestedLimit' => false,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],
        ];
    }

    private function newsArticle(): array
    {
        return [
            [
                'name' => 'Text segment',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'text')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'icon' => 'layer-group',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 4,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],

            [
                'name' => 'Banner',
                'field_type' => 'element',
                'element_id' => ContentElement::query()->where('slug', 'banner')->first()?->id,
                'data' => [
                    'fieldId' => 'group',
                    'icon' => 'layer-group',
                    'nestable' => true,
                    'componentName' => false,
                    'nestedLimit' => 4,
                    'editable' => true,
                    'repeatable' => true,
                    'optionsMenuVisible' => false,
                ],
            ],
        ];
    }
}
