<?php

namespace Tests;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SortingSettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        foreach ($this->getData() as $setting) {
            Settings::make($setting);
        }
    }

    private function getData(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'New Additions',
                'config_key' => 'automotive-vehicle-sorting-latest',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Price (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-price-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Price (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-price-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Monthly Price (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-monthly-price-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Monthly Price (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-monthly-price-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Mileage (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-mileage-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Mileage (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-mileage-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Manufacture Year (New > Old)',
                'config_key' => 'automotive-vehicle-sorting-age-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Manufacture Year (Old > New)',
                'config_key' => 'automotive-vehicle-sorting-age-desc',
                'type' => 'boolean',
                'value' => true,
            ],
        ];
    }
}
