<?php

namespace App\Http\Controllers;

use App\BookingRepository;
use App\Http\Requests\ServiceBookingRequest;
use App\Http\Requests\ServiceDeliveryRequest;
use App\Http\Requests\ServiceLocationSelection;
use App\Http\Requests\ServicePackageSelection;
use App\Http\Requests\ServiceTimeLookupRequest;
use App\Http\Requests\ServiceTimeSelection;
use App\Http\Requests\ServiceVehicleLookup;
use App\Http\Resources\BookingResource;
use App\Http\Resources\ServiceAvailabilityResponse;
use App\Http\Resources\ServiceDeliveryResponse;
use App\Http\Resources\ServiceLocationResponse;
use App\Http\Resources\ServiceLookupResponse;
use App\Http\Resources\ServicePackageResponse;
use App\Http\Resources\ServiceTimeSelectionResponse;

class ServiceBookingController extends Controller
{
    public function vehicleLookup(ServiceVehicleLookup $request, BookingRepository $repository): ServiceLookupResponse
    {
        $booking = $repository->createDraft($request->input());
        return new ServiceLookupResponse($booking)->withRepository($repository);
    }

    public function setLocation(
        ServiceLocationSelection $request,
        BookingRepository $repository
    ): ServiceLocationResponse {
        $booking = $repository->setLocation($request->input('booking_id'), $request->input('location_id'));
        return new ServiceLocationResponse($booking)->withRepository($repository);
    }

    public function setPackage(
        ServicePackageSelection $request,
        BookingRepository $repository
    ): ServicePackageResponse {
        $booking = $repository->setPackage($request->input('booking_id'), $request->input('package'));
        return new ServicePackageResponse($booking)->withRepository($repository);
    }

    public function getAvailability(
        ServiceTimeLookupRequest $request,
        BookingRepository $repository
    ): ServiceAvailabilityResponse {
        $booking = $repository->loadBooking($request->input('booking_id'));
        return new ServiceAvailabilityResponse($booking)->withRepository($repository);
    }

    public function setAvailability(
        ServiceTimeSelection $request,
        BookingRepository $repository
    ): ServiceTimeSelectionResponse {
        $booking = $repository->setTime(
            $request->input('booking_id'),
            $request->input('date'),
            $request->input('time')
        );
        return new ServiceTimeSelectionResponse($booking)->withRepository($repository);
    }

    public function setDelivery(ServiceDeliveryRequest $request, BookingRepository $repository): ServiceDeliveryResponse
    {
        $booking = $repository->setDelivery($request->input('booking_id'), $request->input('delivery_option_id'));
        return new ServiceDeliveryResponse($booking)->withRepository($repository);
    }

    public function store(ServiceBookingRequest $request, BookingRepository $repository): BookingResource
    {
        $booking = $repository->book($request->input());
        return new BookingResource($booking);
    }
}
