<?php

namespace App\Http\Controllers;

use App\Facades\Settings;
use App\Http\Resources\SiteResource;
use App\Traits\CacheObject;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SiteController extends Controller
{
    use CacheObject;

    /**
     * Show page detail
     *
     * @param $page
     * @return SiteResource
     */
    public function index(Request $request): SiteResource|Response|JsonResponse|array
    {
//        return $this->cache('get-site', 5, fn() => new SiteResource([]));
        return $this->cache('get-site', 5, fn() => new SiteResource([])->toResponse($request));
    }

    public function checkAccess(Request $request)
    {
        return $request->input('password') === Settings::get('site-access-password')
            ? response('Access Granted')
            : response('Access Denied', 403);
    }
}
