<?php

namespace App\Http\Requests;

use App\Facades\Feature;
use App\Rules\AllConfiguratorSectionsCompleted;
use App\Rules\CarConfigurationSelectionIsValid;

class StoreConfiguratorRequest extends SubmitEnquiryRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    #[\Override]
    public function authorize(): bool
    {
        return Feature::isEnabled('car-configurator') && $this->isActiveModel();
    }

    #[\Override]
    public function rules()
    {
        return array_merge([] /*parent::rules()*/, [
            'sections' => [
                'required',
                'array',
                new AllConfiguratorSectionsCompleted($this->model)
            ],
            'sections.*.id' => [
                'required',
                'exists:car_configurator_sections,id'
            ],
            'sections.*' => [
                'array',
                new CarConfigurationSelectionIsValid($this->model, $this->input('sections'))
            ],
        ]);
    }

    private function isActiveModel(): bool
    {
        return (bool)$this->model?->active;
    }
}
