<?php

namespace App\Http\Resources;

use App\BookingRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BookingResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    #[\Override]
    public function toArray(Request $request): array
    {
        $this->resource->makeHidden([
            'id',
            'created_at',
            'updated_at',
            'location',
        ]);
        if ($this->resource->relationLoaded('location')) {
            $this->resource->location_name = $this->resource->location->name;
        }
        return parent::toArray($request);
    }
}
