<?php

namespace App\Http\Resources\LeaseVehicleAction;

use App\Facades\Settings;
use App\Http\Resources\FormViewResource;
use Mtc\MercuryDataModels\Form;
use Mtc\MercuryDataModels\KeyloopLeaseVehicleVariant;

trait LoadsLeaseVehicleAction
{
    public function getLeaseVehicleActions(KeyloopLeaseVehicleVariant $vehicle): array
    {
        return [
            'enquiry' => $this->enquireAction($vehicle),
        ];
    }

    private function enquireAction(KeyloopLeaseVehicleVariant $vehicle): ?array
    {
        $form = Form::query()
            ->where('is_active', 1)
            ->when(
                Settings::get('lease-vehicle-enquiry-form-id'),
                fn($query) => $query->where('id', Settings::get('lease-vehicle-enquiry-form-id')),
                fn($query) => $query->whereHas('type', fn($query) => $query->where('name', 'Lease Vehicle Enquiry'))
            )
            ->with('sections.questions')
            ->first();

        return [
            'type' => 'form',
            'title' => 'Make an enquiry',
            'details' => $form
                ? new FormViewResource($form)->setValues([
                    'vehicle_id' => $vehicle->id,
                ])
                : [],
        ];
    }
}
