<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ListingResource extends JsonResource
{
    public function __construct(
        $resource,
        protected $categories = null,
        protected $tags = null,
        protected $featured = null
    ) {
        parent::__construct($resource);
    }

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    #[\Override]
    public function toArray(Request $request)
    {
        return [
            'items' => new PageListResource($this->resource)->toArray($request),
            'featured' => !empty($this->featured)
                ? new PageListResource($this->featured)->toArray($request)
                : null,
            'categories' => $this->categories?->pluck('name', 'slug'),
            'tags' => $this->tags?->pluck('name', 'slug')
        ];
    }
}
