<?php

namespace App\Http\Resources;

use App\Facades\Settings;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\VehicleMake;

class MakeListResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    #[\Override]
    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $this->resource->through(fn(VehicleMake $record) => $this->map($record));
        } else {
            $this->resource = $this->resource->map(fn(VehicleMake $record) => $this->map($record));
        }
        return parent::toArray($request);
    }

    protected function map(VehicleMake $record)
    {
        return [
            'name' => $record->name,
            'image' => $record->logo,
            'image_mono' => $record->monochrome_logo,
            'primary_colour' => '#' . ltrim($record->primary_colour ?? Settings::get('app-primary-colour'), '#') ,
            'secondary_colour' => '#' . ltrim($record->secondary_colour ?? Settings::get('app-secondary-colour'), '#'),
            'url' => $record->slug,
        ];
    }
}
