<?php

namespace App\Http\Resources;

use App\BookingRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceAvailabilityResponse extends JsonResource
{
    public static $wrap = '';
    private BookingRepository $repository;

    public function withRepository(BookingRepository $repository): self
    {
        $this->repository = $repository;
        return $this;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    #[\Override]
    public function toArray(Request $request): array
    {
        return $this->repository->getAvailability(
            $request->input('month'),
            $this->resource->location_id
        )->toArray();
    }
}
