<?php

namespace App\Http\Resources;

use App\BookingRepository;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceDeliveryResponse extends JsonResource
{
    public static $wrap = '';
    private BookingRepository $repository;

    public function withRepository(BookingRepository $repository): self
    {
        $this->repository = $repository;
        return $this;
    }
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    #[\Override]
    public function toArray(Request $request): array
    {
        $this->resource->load([
            'location',
            'deliveryOption'
        ]);
        return new BookingResource($this->resource)->toArray($request);
    }
}
