<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UiArticleCard extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    #[\Override]
    public function toArray($request)
    {
        $image = $this->resource->subContent
            ->where('slug', 'image')
            ->first()
            ->mediaUses
            ->first();
        return [
            'image' => $image ? [
                'src' => $image->getUrl('side-by-side-cta'),
                'src_half' => $image->getUrl('stacked-cta'),
                'alt' => $image->alt_text,
                'original' => $image->media->getOriginalUrlAttribute(),
            ] : null,
            'title' => $this->resource->subContent->where('slug', 'title')->first()->content,
            'label' => $this->resource->subContent->where('slug', 'label')->first()->content,
            'url' => $this->resource->subContent->where('slug', 'url')->first()->content ?? '#',
        ];
    }
}
