<?php

namespace App\Http\Resources;

use App\VehicleRepository;
use Illuminate\Http\Resources\Json\JsonResource;

class UiResponsiveProductList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    #[\Override]
    public function toArray($request)
    {
        return [
            'name' => $this->resource->name,
            'items' => new VehicleRepository()->featured(null)->toArray($request),
        ];
    }
}
